# -*- coding: UTF-8 -*-
# 作者：huanhuilong
# 标题：Python tornado 框架
# 描述：tornado 服务，极简路由

import tornado.web
import tornado.ioloop


class IndexHandler(tornado.web.RequestHandler):
    """主路由处理类"""

    def get(self):
        """对应http的get请求方式"""
        self.write("Hello Tornado!")


if __name__ == "__main__":
    app = tornado.web.Application([
        (r"/", IndexHandler),
    ])
    app.listen(8000)
    print("* Tornado Web Server 已在 8000 端口启动。")
    print("* 请在浏览器里输入 127.0.0.1:8000")
    tornado.ioloop.IOLoop.current().start()
